<?php
// URL da página onde está a tabela de jogos
$url = "https://www.goal.com/br/listas/futebol-programacao-jogos-tv-aberta-fechada-onde-assistir-online-app/bltc0a7361374657315#cs83e2f6668514ea42";

// Função para obter o conteúdo da página usando cURL
function getPageContent($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $output = curl_exec($ch);
    curl_close($ch);
    return $output;
}

// Obtém o conteúdo da página
$htmlContent = getPageContent($url);

// Carrega o HTML em um objeto DOM
$dom = new DOMDocument;
libxml_use_internal_errors(true); // Ignora erros de parsing HTML
$dom->loadHTML($htmlContent);
libxml_clear_errors();

// Usa DOMXPath para buscar a tabela de jogos
$xpath = new DOMXPath($dom);

// Modifique o seletor XPath conforme a estrutura HTML da tabela
$rows = $xpath->query("//div[contains(@class, 'article-body')]//table//tr");

if ($rows->length > 0) {
    // Exibe os dados em uma tabela HTML
    echo '<html><body>';
    echo '<h1>Jogos de Quarta, 28 de Agosto de 2024</h1>';
    echo '<table border="1" cellpadding="10" cellspacing="0">';
    echo '<tr><th>Jogo</th><th>Campeonato</th><th>Horário</th><th>Onde Passa?</th><th>Tempo Real</th></tr>';

    foreach ($rows as $row) {
        $cols = $xpath->query('td', $row);
        echo '<tr>';
        foreach ($cols as $col) {
            echo '<td>' . trim($col->nodeValue) . '</td>';
        }
        echo '</tr>';
    }

    echo '</table>';
    echo '</body></html>';
} else {
    echo "Não foi possível encontrar a tabela de jogos.";
}
?>
